package main;

import java.util.ArrayList;
import java.util.LinkedList;

import javax.swing.JFrame;

import race.ObservableList;
import race.Operation;
import race.ProcessingTimeRace;
import race.Ranking;
import race.operations.ArrayListSortingWithBubbleSort;
import race.operations.ArrayListSortingWithCollectionsSort;
import race.operations.ListAdder;
import ui.RaceRankViewer;

public class ProcessingTimeRaceMain {

	private static ObservableList<Ranking> list = new ObservableList<Ranking>();

	public static void main(String[] args) {
		JFrame frame = new JFrame();
		frame.getContentPane().add(new RaceRankViewer(list));
		frame.setVisible(true);
		frame.setSize(300, 300);
		ArrayList<Operation> listOperations = new ArrayList<Operation>();
		listOperations.add(new ListAdder(new ArrayList<Integer>(), "Element addition to an ArrayList<Integer>"));
		listOperations.add(new ArrayListSortingWithCollectionsSort());
		listOperations.add(new ArrayListSortingWithBubbleSort());
		listOperations.add(new ListAdder(new LinkedList<Integer>(), "Element addition to a LinkedList<Integer>"));
		ProcessingTimeRace race = new ProcessingTimeRace(listOperations, 1000);
		list.setList(race.getRaceRank());
	}

}
